import ctypes
from ctypes import *


lib = ctypes.CDLL('MCSControl.dll')     #load C library


def move_absolute(system_index, channel_index, movement):

    position = ctypes.c_int(movement)

    lib.SA_GotoPositionAbsolute_S.argtypes = [ctypes.c_uint, ctypes.c_uint, ctypes.c_int, ctypes.c_uint]    #C function call
    result = lib.SA_GotoPositionAbsolute_S(system_index, channel_index, position, 60000)
    return result


def move_relative(system_index, channel_index, movement):

    position = ctypes.c_int(movement)

    lib.SA_GotoPositionRelative_S.argtypes = [ctypes.c_uint, ctypes.c_uint, ctypes.c_int, ctypes.c_uint]
    result = lib.SA_GotoPositionRelative_S(system_index, channel_index, position, 60000)
    return result


def get_position(system_index, channel_index):
    position = ctypes.c_int()

    lib.SA_GetPosition_S.argtypes = [ctypes.c_uint, ctypes.c_uint, POINTER(ctypes.c_int)]
    result = lib.SA_GetPosition_S(system_index, channel_index, position)
    return position.value


def get_status(system_index, channel_index):
    status = ctypes.c_int()
    lib.SA_GetStatus_S.argtypes = [ctypes.c_uint, ctypes.c_uint, POINTER(ctypes.c_int)]
    result = lib.SA_GetStatus_S(system_index, channel_index, status)
    return status


def get_scale(system_index, channel_index):
    scale = ctypes.c_int()
    inverted = ctypes.c_uint()

    lib.SA_GetPosition_S.argtypes = [ctypes.c_uint, ctypes.c_uint, POINTER(ctypes.c_int), POINTER(ctypes.c_uint)]
    result = lib.SA_GetPosition_S(system_index, channel_index, scale, inverted)
    return scale.value
